/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.controller;

import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import pt.caf_pbs.schooldiskapi.dao.FilesOperation;
import pt.caf_pbs.schooldiskapi.dto.EnrollCreateDTO;
import pt.caf_pbs.schooldiskapi.dto.EnrollEditDTO;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.Enroll;
import pt.caf_pbs.schooldiskapi.model.Pair;
import pt.caf_pbs.schooldiskapi.model.School;
import pt.caf_pbs.schooldiskapi.model.Student;
import pt.caf_pbs.schooldiskapi.model.Subject;

@RestController
@RequestMapping(value={"/v1/enroll"})
public class EnrollsController {
    @PostMapping
    public Enroll createEnroll(@RequestBody EnrollCreateDTO enrollDTO) {
        School school = FilesOperation.loadSchool();
        try {
            Student student = school.getStudentContainer().get(enrollDTO.getStudentNumber());
            if (student == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Student with id " + enrollDTO.getStudentNumber() + " found");
            }
            Subject subject = school.getSubjectContainer().get(enrollDTO.getSubjectInitials());
            if (subject == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No subject initials " + enrollDTO.getSubjectInitials() + " found");
            }
            Enroll enroll = new Enroll(enrollDTO.getGrade(), subject, student);
            school.getEnrollContainer().add(enroll);
            FilesOperation.storeSchool((School)school);
            return enroll;
        }
        catch (DuplicatedDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(path={"{studentId}/subjects"})
    public List<Pair<Subject, Integer>> getStudentSubjects(@PathVariable Integer studentId) {
        School school = FilesOperation.loadSchool();
        Student student = school.getStudentContainer().get(studentId.intValue());
        if (student != null) {
            List enrolls = school.getStudentContainer().getEnrolls().getSubjects(studentId.intValue());
            if (enrolls != null) {
                return enrolls;
            }
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Enrolls with studentId" + studentId + " found");
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Student with id " + studentId + " found");
    }

    @GetMapping(path={"{studentId}/subject/{subjectInitials}"})
    public Enroll getStudentSubject(@PathVariable Integer studentId, @PathVariable String subjectInitials) {
        School school = FilesOperation.loadSchool();
        Student student = school.getStudentContainer().get(studentId.intValue());
        if (student != null) {
            Enroll enroll = school.getStudentContainer().getEnrolls().get(studentId.intValue(), subjectInitials);
            if (enroll != null) {
                return enroll;
            }
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Enroll with studentId" + studentId + "  and subject initials " + subjectInitials + " found");
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Student with id " + studentId + " found");
    }

    @PutMapping(path={"{studentId}/subject/{subjectInitials}"})
    public void updateLecture(@PathVariable Integer studentId, @PathVariable String subjectInitials, @RequestBody EnrollEditDTO enrollDTO) {
        School school = FilesOperation.loadSchool();
        try {
            school.getStudentContainer().getEnrolls().update(studentId.intValue(), subjectInitials, enrollDTO.getGrade());
            FilesOperation.storeSchool((School)school);
        }
        catch (DuplicatedDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), (Throwable)e);
        }
    }

    @DeleteMapping(path={"{studentId}/subject/{subjectInitials}"})
    public Enroll deleteLecture(@PathVariable Integer studentId, @PathVariable String subjectInitials) {
        Enroll enroll = this.getStudentSubject(studentId, subjectInitials);
        if (enroll != null) {
            School school = FilesOperation.loadSchool();
            school.getStudentContainer().getEnrolls().remove(studentId.intValue(), subjectInitials);
            FilesOperation.storeSchool((School)school);
            return enroll;
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Enroll with studentId" + studentId + "  and subject initials " + subjectInitials + " found");
    }
}

